/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWebAppComboBox;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.uicontrols.border.VWInfoLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWStepProcessorRegistrationDialog
extends VWModalDialog
implements ActionListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private int m_nProcessorType = 8;
    private Hashtable m_webAppTable = null;
    private VWWebAppComboBox m_applicationComboBox = null;
    private JLabel m_openMessageLabel = null;
    private JButton m_openBrowserButton = null;
    private JTextField m_nameTextfield = null;
    private JTextField m_urlTextfield = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWStepProcessorRegistrationDialog(VWAuthPropertyData authPropertyData, int nProcessorType) {
        super(authPropertyData.getSessionInfo().getParentFrame());
        this.m_authPropertyData = authPropertyData;
        this.m_nProcessorType = nProcessorType;
        try {
            Dimension dim = VWStringUtils.stringToDimension("445,385");
            if (dim != null) {
                this.setSize(dim);
            } else {
                this.setSize(new Dimension(400, 350));
            }
            this.setTitle(VWResource.s_registeringANewStepProcessor);
            this.createControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_applicationComboBox)) {
                switch (this.getSelectedWebAppId()) {
                    case 8: 
                    case 9: {
                        this.m_openMessageLabel.setVisible(true);
                        this.m_openBrowserButton.setVisible(true);
                        break;
                    }
                    default: {
                        this.m_openMessageLabel.setVisible(false);
                        this.m_openBrowserButton.setVisible(false);
                        break;
                    }
                }
            } else if (source.equals(this.m_openBrowserButton)) {
                VWOpenItem openItem;
                String urlValue = this.m_urlTextfield.getText();
                if (!(urlValue != null && urlValue.length() != 0 || this.m_webAppTable == null || this.m_webAppTable.isEmpty())) {
                    switch (this.getSelectedWebAppId()) {
                        case 9: {
                            urlValue = (String)this.m_webAppTable.get(new Integer(9));
                            break;
                        }
                        case 8: {
                            urlValue = (String)this.m_webAppTable.get(new Integer(8));
                        }
                    }
                }
                if (urlValue != null && urlValue.length() > 0 && (openItem = this.m_authPropertyData.getDesignerCoreData().getOpenItem()) != null) {
                    openItem.displayURL(urlValue);
                }
            } else if (source.equals(this.m_okButton)) {
                VWDataDictionary dataDictionary;
                int nWebAppId = this.getSelectedWebAppId();
                String name = this.m_nameTextfield.getText();
                String location = this.m_urlTextfield.getText();
                if (location != null && location.length() > 0) {
                    boolean bValidURL = false;
                    switch (nWebAppId) {
                        case 9: {
                            String token;
                            int nEndIndex;
                            int nStartIndex = location.indexOf("spaceId=");
                            if (nStartIndex != -1 && (nEndIndex = location.indexOf("&pageId=", nStartIndex)) != -1) {
                                location = (nEndIndex = location.indexOf("&", nEndIndex + 1)) != -1 ? location.substring(nStartIndex, nEndIndex).trim() : location.substring(nStartIndex).trim();
                                bValidURL = true;
                            }
                            if (bValidURL || (nStartIndex = location.indexOf(token = "?nst=pid%3D")) == -1) break;
                            int nEndIndex2 = location.indexOf("%26", nStartIndex + 1);
                            location = nEndIndex2 != -1 ? location.substring(nStartIndex + token.length(), nEndIndex2).trim() : location.substring(nStartIndex + token.length()).trim();
                            bValidURL = true;
                            break;
                        }
                        case 8: {
                            int nEndIndex;
                            String token = "#pid=";
                            int nStartIndex = location.indexOf(token);
                            if (nStartIndex != -1) {
                                nEndIndex = location.indexOf("&", nStartIndex + 1);
                                location = nEndIndex != -1 ? location.substring(nStartIndex + token.length(), nEndIndex).trim() : location.substring(nStartIndex + token.length()).trim();
                                bValidURL = true;
                            }
                            if (bValidURL || (nStartIndex = location.indexOf(token = "?nst=pid%3D")) == -1) break;
                            nEndIndex = location.indexOf("%26", nStartIndex + 1);
                            location = nEndIndex != -1 ? location.substring(nStartIndex + token.length(), nEndIndex).trim() : location.substring(nStartIndex + token.length()).trim();
                            bValidURL = true;
                            break;
                        }
                        default: {
                            bValidURL = true;
                        }
                    }
                    if (!bValidURL) {
                        throw new VWException("vw.toolkit.utils.VWStepProcessorRegistrationDialogInvalidURL", "The URL does not appear to be formatted correctly.");
                    }
                }
                if ((dataDictionary = this.m_authPropertyData.getDesignerCoreData().getDataDictionary()).createStepProcessor(name, this.m_nProcessorType, new Integer(nWebAppId), location)) {
                    VWCoordinationEvent coordEvent = new VWCoordinationEvent(this, 765, null);
                    this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(coordEvent);
                    this.m_nExitStatus = 0;
                    this.setVisible(false);
                }
            } else if (source.equals(this.m_cancelButton)) {
                this.m_nExitStatus = 1;
                this.setVisible(false);
            } else if (source.equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh155.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
        }
    }

    protected void reinitialize() throws VWException {
        this.m_webAppTable = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getWebApplications();
        this.m_applicationComboBox.initialize(this.m_webAppTable);
        if (this.m_applicationComboBox.getModel().getSize() > 0) {
            this.m_applicationComboBox.setSelectedIndex(0);
        }
        this.m_nameTextfield.setText(null);
        this.m_urlTextfield.setText(null);
    }

    protected String getStepProcessorName() {
        return this.m_nameTextfield.getText();
    }

    public void releaseReferences() {
        if (this.m_applicationComboBox != null) {
            this.m_applicationComboBox.removeActionListener(this);
            this.m_applicationComboBox = null;
        }
        this.m_openMessageLabel = null;
        if (this.m_openBrowserButton != null) {
            this.m_openBrowserButton.removeActionListener(this);
            this.m_openBrowserButton = null;
        }
        this.m_nameTextfield = null;
        this.m_urlTextfield = null;
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
    }

    private void createControls() {
        try {
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(15, 10, 1, 5);
            gbCons.gridheight = 1;
            gbCons.gridwidth = -1;
            JLabel numberOneLabel = new JLabel(VWImageLoader.createImageIconNoMessage("number_1.gif"));
            VWAccessibilityHelper.setAccessibility(numberOneLabel, this, VWResource.s_one, VWResource.s_one);
            mainPanel.add((Component)numberOneLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(10, 10, 1, 5);
            gbCons.gridwidth = 0;
            mainPanel.add((Component)this.getNumberOneMessagePanel(), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(35, 10, 1, 5);
            gbCons.gridwidth = -1;
            JLabel numberTwoLabel = new JLabel(VWImageLoader.createImageIconNoMessage("number_2.gif"));
            VWAccessibilityHelper.setAccessibility(numberTwoLabel, this, VWResource.s_two, VWResource.s_two);
            mainPanel.add((Component)numberTwoLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(30, 10, 1, 5);
            gbCons.gridwidth = 0;
            mainPanel.add((Component)this.getNumberTwoMessagePanel(), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(35, 10, 1, 5);
            gbCons.gridwidth = -1;
            JLabel numberThreeLabel = new JLabel(VWImageLoader.createImageIconNoMessage("number_3.gif"));
            VWAccessibilityHelper.setAccessibility(numberThreeLabel, this, VWResource.s_three, VWResource.s_three);
            mainPanel.add((Component)numberThreeLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(30, 10, 1, 5);
            gbCons.gridwidth = 0;
            JTextArea lastMessageTextArea = new JTextArea(VWResource.s_registeredStepProcessorMessage);
            lastMessageTextArea.setOpaque(false);
            lastMessageTextArea.setEditable(false);
            lastMessageTextArea.setLineWrap(true);
            lastMessageTextArea.setWrapStyleWord(true);
            VWAccessibilityHelper.setAccessibility(lastMessageTextArea, this, VWResource.s_registeredStepProcessorMessage, VWResource.s_registeredStepProcessorMessage);
            mainPanel.add((Component)lastMessageTextArea, gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getNumberOneMessagePanel() {
        try {
            JPanel messagePanel = new JPanel(new BorderLayout());
            JLabel titleLabel = new JLabel(VWResource.s_selectAnApplication);
            VWAccessibilityHelper.setAccessibility(titleLabel, this, VWResource.s_selectAnApplication, VWResource.s_selectAnApplication);
            messagePanel.add((Component)titleLabel, "First");
            this.m_applicationComboBox = new VWWebAppComboBox();
            this.m_applicationComboBox.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_applicationComboBox, this, VWResource.s_applicationList, VWResource.s_applicationList);
            messagePanel.add((Component)this.m_applicationComboBox, "Last");
            return messagePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getNumberTwoMessagePanel() {
        try {
            JPanel messagePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            JTextArea messageTextArea = new JTextArea(VWResource.s_stepProcessorRegistrationInstructions);
            messageTextArea.setOpaque(false);
            messageTextArea.setEditable(false);
            messageTextArea.setLineWrap(true);
            messageTextArea.setWrapStyleWord(true);
            VWAccessibilityHelper.setAccessibility(messageTextArea, this, VWResource.s_stepProcessorRegistrationInstructions, VWResource.s_stepProcessorRegistrationInstructions);
            messagePanel.add((Component)messageTextArea, gbCons);
            gbCons.anchor = 22;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(5, 1, 1, 1);
            gbCons.gridwidth = -1;
            this.m_openMessageLabel = new JLabel(VWResource.s_clickToCreateNewStepProcessor);
            this.m_openMessageLabel.setVisible(false);
            VWAccessibilityHelper.setAccessibility(this.m_openMessageLabel, this, VWResource.s_clickToCreateNewStepProcessor, VWResource.s_clickToCreateNewStepProcessor);
            messagePanel.add((Component)this.m_openMessageLabel, gbCons);
            gbCons.anchor = 23;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_openBrowserButton = (JButton)VWImageLoader.createToolBarButton("small_arrow.gif", VWResource.s_clickToCreateNewStepProcessor, false);
            this.m_openBrowserButton.setMargin(new Insets(0, 5, 0, 5));
            this.m_openBrowserButton.addActionListener(this);
            this.m_openBrowserButton.setVisible(false);
            VWAccessibilityHelper.setAccessibility(this.m_openBrowserButton, this, VWResource.s_clickToCreateNewStepProcessor, VWResource.s_clickToCreateNewStepProcessor);
            messagePanel.add((Component)this.m_openBrowserButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            VWInfoLabel nameLabel = new VWInfoLabel(VWResource.s_name);
            VWAccessibilityHelper.setAccessibility(nameLabel, this, VWResource.s_name, VWResource.s_name);
            messagePanel.add((Component)nameLabel, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(1, 1, 1, 1);
            this.m_nameTextfield = new JTextField();
            this.m_nameTextfield.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_nameTextfield, this, VWResource.s_nameTextField, VWResource.s_nameTextField);
            messagePanel.add((Component)this.m_nameTextfield, gbCons);
            ++gbCons.gridy;
            VWInfoLabel urlLabel = new VWInfoLabel(VWResource.s_URL);
            VWAccessibilityHelper.setAccessibility(urlLabel, this, VWResource.s_URL, VWResource.s_URL);
            messagePanel.add((Component)urlLabel, gbCons);
            ++gbCons.gridy;
            this.m_urlTextfield = new JTextField();
            this.m_urlTextfield.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_urlTextfield, this, VWResource.s_urlTextField, VWResource.s_urlTextField);
            messagePanel.add((Component)this.m_urlTextfield, gbCons);
            return messagePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private int getSelectedWebAppId() {
        Integer webAppId = this.m_applicationComboBox.getSelectedWebApp();
        if (webAppId != null) {
            return webAppId;
        }
        return -1;
    }
}

